﻿<%@ Page Title="" Language="vb" AutoEventWireup="false" MasterPageFile="~/private/Private.Master" CodeBehind="gestionentorno.aspx.vb" Inherits="Web.gestionentorno" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <script type="text/javascript">
        function pageLoad() {
            var mpe = '<%= MPE_PanelErrores.ClientID %>';
            var background = $get(mpe + '_backgroundElement');
            if (background) $addHandler(background, 'click', hideModalPopupViaClient);
            return false;

        }
        function hideModalPopupViaClient() {
            var modalPopupBehavior = $find('<%= MPE_PanelErrores.ClientID %>');
            if (modalPopupBehavior) modalPopupBehavior.hide();
        }
    </script>
    <asp:UpdatePanel runat="server" ID="UpdatePanelRegistration" UpdateMode="Conditional">
        <ContentTemplate>

            <div class="block private">

                <div class="add-panel">
                    <div class="container">
                        <h2><%= Translator.Translate("ADMIN_ENVIRONMENT_TITLE")%></h2>
                    </div>
                </div>
                <div class="content ajax-tabs">

                    <div class="reg-form" runat="server" id="DivCamps">
                        <fieldset>
                            <div class="row private">
                                <asp:Label ID="lblUdsTemperatura" runat="server" CssClass="label"></asp:Label>
                                <asp:DropDownList ID="UdsTemperatura" runat="server" CssClass="input"></asp:DropDownList>
                            </div>
                            <div class="row private" id="divModoEstaciones" runat="server" visible="false">
                                <asp:Label ID="lblModoVisualizacion" runat="server" CssClass="label"></asp:Label>
                                <asp:DropDownList ID="ModoEstaciones" runat="server" CssClass="input">
                                </asp:DropDownList>
                            </div>
                            <div class="row private">
                                <asp:Label ID="lblIdioma" runat="server" CssClass="label"></asp:Label>
                                <asp:DropDownList ID="Idioma" runat="server" CssClass="input">
                                </asp:DropDownList>
                            </div>
                            <div class="row private" id="divVelocidadRefresco" runat="server" visible="false">
                                <asp:Label ID="lblVelocidadRefresco" runat="server" CssClass="label" Width="120px"></asp:Label>
                                <asp:TextBox ID="VelocidadRefresco" runat="server" CssClass="input" Width="110px" Text=""></asp:TextBox>
                            </div>
                            <div class="row">
                                <br />
                                <asp:Button ID="btnGuardar" runat="server" CssClass="btn" Text="Guardar" />
                                <asp:Button ID="btnCancelar" runat="server" CssClass="btn" Text="Cancelar" Style="float: right;" />
                            </div>
                        </fieldset>
                    </div>
                </div>
            </div>

            <!--Panel de errores del formulario de registro -->
            <asp:Panel ID="PanelErrores" runat="server" Style="display: none" CssClass="error-message">
                <div class="holder">
                    <asp:Literal ID="infoerrores" runat="server"></asp:Literal>
                    <a id="btnCancelar_PanelErrores" href="#" runat="server" class="btn">Ok</a>
                </div>
            </asp:Panel>

            <!-- controles ajax-->
            <ajaxToolkit:ModalPopupExtender ID="MPE_PanelErrores" runat="server" TargetControlID="hdnPanelErrores" PopupControlID="PanelErrores" BackgroundCssClass="" CancelControlID="btnCancelar_PanelErrores" DropShadow="false" PopupDragHandleControlID="" />

            <!-- controles ocultos-->
            <asp:HiddenField ID="hdnPanelErrores" runat="server" />

        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="btnGuardar" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="btnCancelar" EventName="Click" />
        </Triggers>
    </asp:UpdatePanel>
    <ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderRegistration" TargetControlID="UpdatePanelRegistration" BehaviorID="animation" runat="server">
        <Animations>    
            <OnUpdated>
                <Sequence>
                    <FadeIn AnimationTarget="PanelErrores" Duration="0.15" minimumOpacity=".3"  />
                    <EnableAction AnimationTarget="btnCancelar_PanelErrores" Enabled="true" />
                    <ScriptAction Script="initRefreshFunctions();" />
                </Sequence>
            </OnUpdated>
        </Animations>
    </ajaxToolkit:UpdatePanelAnimationExtender>

</asp:Content>
